USE [impresario]
GO

/****** Object:  UserDefinedFunction [dbo].[LFT_WF_ABANDONED_CART]    Script Date: 07/03/2012 10:50:16 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

-- =============================================
-- Author:		<Tessitura Network>
-- Create date: <2023.29.11>
-- Description:	<Sample abandoned cart code intended for signposting purposes. May need customization by member>
-- =============================================

CREATE TABLE [dbo].[LT_WF_ABANDONED_CART](
	[customer_no] [int] NOT NULL,
	[order_no] [int] NULL,
	[order_dt] [datetime] NULL,
	[orderdetail1] [varchar](250) NULL,
	[orderdetail2] [varchar](250) NULL,
	[orderdetail3] [varchar](250) NULL,
	[datecreated] [datetime] NULL,
 CONSTRAINT [PK_LT_ABANDONED_CART] PRIMARY KEY CLUSTERED 
(
	[customer_no] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[LT_WF_ABANDONED_CART] ADD  CONSTRAINT [DF_LT_WF_ABANDONED_CART_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO



-- =============================================
-- Author:		<Tessitura Network>
-- Create date: <2023.29.11>
-- Description:	<Sample abandoned cart code intended for signposting purposes. May need customization by member>
-- =============================================
CREATE PROCEDURE [dbo].[LP_WF_ABANDONED_CART]
(
	@daysAbandoned int
)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    --  CLEAR EXISTING DATA
	delete from LT_WF_ABANDONED_CART

	--  FIND CUSTOMERS WITH ABANDONED CARTS
	declare @cutoffDate datetime
	set @cutoffDate = DateAdd(dd,-@daysAbandoned,Convert(varchar,GetDate(),112)+' 23:59:59')

	insert into LT_WF_ABANDONED_CART (customer_no,order_no,order_dt)	
	select customer.customer_no,max(cart.order_no),max(cart.order_dt)  
	from t_customer customer (NOLOCK)
	join dbo.T_WEB_ORDER cart (NOLOCK) on customer.customer_no = cart.customer_no
	left outer join dbo.T_ORDER cart_order (NOLOCK) on cart.order_no = cart_order.order_no
	left outer join dbo.T_ORDER customer_order (NOLOCK) on customer.customer_no = customer_order.customer_no and customer_order.order_dt > cart.order_dt
	where (cart_order.order_no is null) 
	and (customer_order.order_no is null) 
	and (cart.order_dt >= @cutoffDate)
	group by customer.customer_no

	--  POPULATE ABANDONED CART DATA
	


	--  RETURN CUSTOMERS
	select distinct customer_no from LT_WF_ABANDONED_CART	


END

GO




-- =============================================
-- Author:		<Tessitura Network>
-- Create date: <2023.29.11>
-- Description:	<Sample abandoned cart code intended for signposting purposes. May need customization by member>
-- =============================================
CREATE FUNCTION [dbo].[LFT_WF_ABANDONED_CART]
(
	@daysAbandoned int
)
RETURNS @customers TABLE 
(
	customer_no int
)
AS
BEGIN
	
	declare @cutoffDate datetime
	set @cutoffDate = DateAdd(dd,-@daysAbandoned,Convert(varchar,GetDate(),112)+' 23:59:59')

	insert into @customers
	select distinct customer_no from LT_WF_ABANDONED_CART
	where order_dt >= @cutoffDate	
	
	RETURN 
END

GO


GRANT EXECUTE ON  [dbo].[LP_WF_ABANDONED_CART] TO [ImpUsers], [Tessitura_app]
GO

GRANT SELECT, EXECUTE ON  [dbo].[LFT_WF_ABANDONED_CART] TO [ImpUsers], [Tessitura_app]
GO


GRANT SELECT ON  [dbo].[LT_WF_ABANDONED_CART]  TO [ImpUsers], [Tessitura_app]
GO